/* FILE: mlatlon.h                              (D. Tottingham  09/01/89)

This is an include file of defines, data structure definitions and
external declarations that are common in the mlatlon module.

*/

#ifndef _MLATLON_
#define _MLATLON_


/************************************************************************
                               INCLUDES

************************************************************************/
#include "mconst.h"


/************************************************************************
                                DEFINES

************************************************************************/
#define PI              3.14159265
#define TWOPI           2.0 * (PI)
#define HALFPI          0.5 * (PI)
#define RAD             (PI) / 180.0
#define DEG             1.0 / (RAD)
#define EQURAD          6378.2064
#define EQURADSQ        (EQURAD) * (EQURAD)
#define POLRAD          6356.5838
#define POLRADSQ        (POLRAD) * (POLRAD)
#define FLAT            ((EQURAD) - (POLRAD)) / EQURAD
#define C1              (1.0 - (FLAT)) * (1.0 - (FLAT))
#define C2              (HALFPI) * (1.0 / (C1) - 1.0)


/************************************************************************
                        STRUCTURE DEFINITIONS

The following structure definitions are included here so that all
modules can have access to them.

************************************************************************/
typedef struct {
        double lat;
        double lon;
} LL_LATLON;

typedef struct {
        double r;
        double theta;
} LL_POLAR;

typedef struct {
        double x;
        double y;
} LL_XY;


/************************************************************************
                         EXTERNAL DECLARATIONS

These functions can be called from all modules that include this file.

************************************************************************/
PUBLIC LL_LATLON ll_fold (double, double);
PUBLIC LL_LATLON ll_to_latlon (double, double, LL_LATLON);
PUBLIC LL_XY ll_to_xy (double, double, LL_LATLON);

#endif
